#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//VoxelMazeMod01.fsh by  namanonamako
//https://www.shadertoy.com/view/NsjyRc
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
Reference
	Voxel Ambient Occlusion - fb39ca4
    https://www.shadertoy.com/view/ldl3DS
*/

//precision highp float;

uniform vec2 mouse;
uniform vec2 resolution;

float rand(vec3 p){
	return fract(sin(dot(p, vec3(23.5349, 12.4324, 94.5204))) * 8471.4309);
}

float rand(vec2 p){
	return fract(sin(dot(p, vec2(23.5349, 94.5204))) * 8471.4309);
}

vec3 path(float a){
	return vec3(pow(sin(a * .6), 2.) - 2. * exp(cos(a * .2 + 1.)), cos(a) * .6 + sin(a * 1.6) * .5, a);
}

vec3 path2(float a){
	return vec3(pow(sin(a + 1.), 2.) - 2.3, cos(a * 1.3) * .6 + sin(a + 2.1) * .5, a);
}

vec3 path3(float a){
	return vec3(sin(a * 1.2 + 3.) * 2.2 + 1.5, cos(a + 6.1) * 1.2, a);
}

float map(vec3 p){
	float d1 = length(p - path(p.z)) - 1.;
	float d2 = length(p - path2(p.z)) - 1.;
    float d3 = length(p - path3(p.z)) - .75;
	return -min(d1, min(d2, d3));
}

float vertexAo(vec2 side, float corner) {
	//if (side.x == 1.0 && side.y == 1.0) return 1.0;
	return (side.x + side.y + max(corner, side.x * side.y)) / 3.0;
}

vec4 voxelAo(vec3 pos, vec3 d1, vec3 d2, float res) {
	d1 *= res;
	d2 *= res;
	vec4 side = vec4(map(pos + d1), map(pos + d2), map(pos - d1), map(pos - d2));
	vec4 corner = vec4(map(pos + d1 + d2), map(pos - d1 + d2), map(pos - d1 - d2), map(pos + d1 - d2));
	side = step(side, vec4(0.));
	corner = step(corner, vec4(0.));
	vec4 ao;
	ao.x = vertexAo(side.xy, corner.x);
	ao.y = vertexAo(side.yz, corner.y);
	ao.z = vertexAo(side.zw, corner.z);
	ao.w = vertexAo(side.wx, corner.w);
	return 1.0 - ao;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 

	vec2 p = ( fragCoord.xy * 2. - iResolution.xy )/ min(iResolution.x, iResolution.y);

	vec3 col = vec3(0.0);
	//col.xy = p;
	
	float speed = .5 * iTime;
	
	vec3 cp = vec3(sin(iTime) * 3., 0., -3.);
	cp = path(speed);
	vec3 t = vec3(0.);
	t = path(speed + .5);
	vec3 f = normalize(t - cp);
	vec3 u = vec3(0., 1., 0.);
	vec3 s = normalize(cross(u, f));
	u = normalize(cross(f, s));
	vec3 rd = normalize(p.x * s + p.y * u + f);
	
	float res = .25;
	vec3 mp = floor(cp / res) * res;
	vec3 rs = sign(rd) * res;
	vec3 dd = abs(1. / rd);
	vec3 sd = (sign(rd) * (mp - cp) + (sign(rd) * .5 + .5) * res) * dd;
	
	vec3 mask;
	int k;
	bool hit;
	
	for(int i = 0; i < 100; i++){
		if(map(mp) < 0.){
			hit = true;
			break;
		}
		mask = step(sd, sd.yzx) * step(sd, sd.zxy);
		sd += mask * dd * res;
		mp += mask * rs;
		k = i;
	}
	
	if(hit){
		float depth = dot(sd - dd * res, mask);
		
		vec3 uvw = fract((cp + depth * rd) / res);
		vec2 uv = vec2(dot(uvw.yzx, mask), dot(uvw.zxy, mask));
		vec2 uu = abs(uv - .5);
		float grid = smoothstep(.45, .5, max(uu.x, uu.y));
        
		vec4 ambient;
		ambient = voxelAo(mp - rs * mask, mask.zxy, mask.yzx, res);
		float interpAo = mix(mix(ambient.z, ambient.w, uv.x), mix(ambient.y, ambient.x, uv.x), uv.y);
		interpAo = pow(interpAo, 1.0 / 3.0);
		
		float a = .015;
		float tm = floor(iTime * .2 / a) * a;
		tm = floor(tm) + smoothstep(.8, 1., fract(tm));
		//vec3 surf_col = mix(vec3(.65, .4, .95), vec3(.8), step(rand(mp + tm), .8));
		vec3 surf_col = mix(vec3(.65, .4, .95), vec3(.8), step(rand(mp), .8));
		col += mix(surf_col, vec3(.3, .3, .3), grid);
		
		col *= min(1., 15. / depth / depth);
		interpAo = clamp(interpAo, 0., 1.);
		col *= interpAo * .5 + .5;
	}
	
	col = sqrt(col);
	
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

